﻿namespace Microsoft.Samples.PlanMyNight.AddIns.PrintItinerary
{
    using System.Collections.Generic;
    using System.ComponentModel.Composition;
    using System.Web.Routing;
    using Microsoft.Samples.PlanMyNight.Infrastructure;

    public class ItineraryContextualActionsExport
    {
        [Export(typeof(ExtensionLink))]
        [ExtensionSiteMetadata(TargetExtensionSite = "ItineraryLinks")]
        public ExtensionLink PrintLinkExport
        {
            get
            {
                return new ExtensionLink()
                {
                    LinkText = "Print",
                    RouteLink = new RouteValueDictionary(new { controller = "PrintItinerary", action = "Print", area = RouteTableConfiguration.AreaName }),
                    Attributes = new Dictionary<string, object> {
                        { "id", "printItineraryLink" },
                        { "class", "print" },
                        { "rel", "nofollow" },
                        { "onclick", "window.open(this.href, 'pmn_print', 'width=550,height=400,status=0,toolbar=0,location=0'); return false;" }
                    }
                };
            }
        }
    }
}